/*
 * ma_drv8301.h
 *
 *  Created on: 2016 jan. 28
 *      Author: loszi
 */

#ifndef INCLUDE_MA_DRV8301_H_
#define INCLUDE_MA_DRV8301_H_

/* 15 Read/Write */
#define DRV8301_READ					1U		/* Read command */
#define DRV8301_WRITE					0U		/* Write Command */

/* 14-11 Register address */
#define DRV8301_STATUS_REG_1			0U
#define DRV8301_STATUS_REG_2			1U
#define DRV8301_CONTROL_REG_1			2U
#define DRV8301_CONTROL_REG_2			3U

/* 10-6 OC_ADJ_SET */
/*	0		1		2		3		4		5		6		7		8		9		10		11		12		13		14		15
	0.060 	0.068	0.076	0.086	0.097	0.109	0.123	0.138	0.155	0.175	0.197	0.222	0.250	0.282	0.317	0.358
	16		17		18		19		20		21		22		23		24		25		26		27		28		29		30		31
	0.403	0.454	0.511	0.576	0.648	0.730	0.822	0.926	1.043	1.175	1.324	1.491	1.679	1.892	2.131	2.400
	Do not use settings 28, 29, 30, 31 for VDS sensing if the IC is expected to operate in the 6-V to 8-V range. */
#define DRV8301_OC_ADJ_SET				0U


 /* 5-4 OCP_MODE */
#define DRV8301_OCP_LIMIT				0U		/* Current limit */
#define DRV8301_OCP_SHUT				1U		/* Current limit */
#define DRV8301_OCP_REPORT				2U		/* Report only */
#define DRV8301_OCP_DISABLED			3U		/* OC disabled */

 /* 3 PWM_MODE */
#define DRV8301_PWM_6					0U		/* 6 PWM inputs */
#define DRV8301_PWM_3					1U		/* 3 PWM inputs */

/* 2  GATE_RESET */
#define DRV8301_GATE_NORMAL				0U		/* Normal mode */
#define DRV8301_GATE_RESET				1U		/* Reset gate driver latched faults (reverts to 0) */

/* Control Register 1 for Gate Driver Control (Address: 0x02) */
/* 1-0 GATE_CURRENT */
#define DRV8301_GATE_CURRENT_1_7A		0U		/* Gate drive peak current 1.7 A */
#define DRV8301_GATE_CURRENT_0_7A		1U		/* Gate drive peak current 0.7 A */
#define DRV8301_GATE_CURRENT_0_25A		2U		/* Gate drive peak current 0.25 A */


static uint16 xInitDrv8301CtrlReg1 = (uint16)((uint16)DRV8301_WRITE << 15U)
										| (uint16)((uint16)DRV8301_CONTROL_REG_1 << 11U)
										| (uint16)((uint16)DRV8301_OC_ADJ_SET << 6U)
										| (uint16)((uint16)DRV8301_OCP_REPORT << 4U)
										| (uint16)((uint16)DRV8301_PWM_6 << 3U)
										| (uint16)((uint16)DRV8301_GATE_NORMAL << 2U)
										| (uint16)((uint16)DRV8301_GATE_CURRENT_1_7A << 0U);

/* Control Register 2 for Current Shunt Amplifiers and Misc Control (Address: 0x03) */
/* 6 OC_TOFF */
#define DRV8301_OC_CBC					0		/* Cycle by cycle */
#define DRV8301_OC_ONESHUT				1		/* Off-time control */
/* 5 DC_CAL_CH2 */
#define DRV8301_DCCAL_CH2_OFF			0		/* Shunt amplifier 2 connects to load through input pins */
#define DRV8301_DCCAL_CH2_ON			1		/* Shunt amplifier 2 shorts input pins and disconnects from load for external calibration */
/* 4 DC_CAL_CH1 */
#define DRV8301_DCCAL_CH1_OFF			0		/* Shunt amplifier 1 connects to load through input pins */
#define DRV8301_DCCAL_CH1_ON			1		/* Shunt amplifier 1 shorts input pins and disconnects from load for external calibration */
/* 3-2 GAIN */
#define DRV8301_AMP_GAIN_10				0		/* Gain of shunt amplifier: 10 V/V */
#define DRV8301_AMP_GAIN_20				1		/* Gain of shunt amplifier: 20 V/V */
#define DRV8301_AMP_GAIN_40				2		/* Gain of shunt amplifier: 40 V/V */
#define DRV8301_AMP_GAIN_80				3		/* Gain of shunt amplifier: 80 V/V */
/* 1-0 OCTW_MODE */
#define DRV8301_OCTW_MODE_BOTH			0		/* Report both OT and OC at nOCTW pin */
#define DRV8301_OCTW_MODE_OT			1		/* Report OT only */
#define DRV8301_OCTW_MODE_OC			2		/* Report OC only */

static uint16 xInitDrv8301CtrlReg2 = (uint16)((uint16)DRV8301_WRITE << 15U)
										| (uint16)((uint16)DRV8301_CONTROL_REG_2 << 11U)
										| (uint16)((uint16)DRV8301_OC_CBC << 6U)
										| (uint16)((uint16)DRV8301_DCCAL_CH2_OFF << 5U)
										| (uint16)((uint16)DRV8301_DCCAL_CH1_OFF << 4U)
										| (uint16)((uint16)DRV8301_AMP_GAIN_40 << 2U)
										| (uint16)((uint16)DRV8301_OCTW_MODE_BOTH << 0U);

#define DRV8301_EN_GATE_ON()			gioSetBit(gioPORTB, 4, 1)	/* EN_GATE = 1 */
#define DRV8301_EN_GATE_OFF()			gioSetBit(gioPORTB, 4, 0)	/* EN_GATE = 0 */
#define DRV8301_DC_CAL_ON()				gioSetBit(gioPORTB, 6, 1);	/* DC_CAL = 1 */
#define DRV8301_DC_CAL_OFF()			gioSetBit(gioPORTB, 6, 0);	/* DC_CAL = 0 */


void vInitDrv8301(void);
void vEnableDrv8301(void);
void vDisableDrv8301(void);
uint16_t xReadDrv8301Register(unsigned char ucRegister);

#endif /* INCLUDE_MA_DRV8301_H_ */
