#include "CLI_commands.h"
#include "FreeRTOS.h"
#include "FreeRTOS_IO.h"
#include "os_task.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"


BaseType_t xSetPWMCommand( char *pcWriteBuffer, size_t xWriteBufferLen, const char *pcCommandString )
{
	char *pcPwmValueA, *pcPwmValueB, *pcPwmValueC;
	BaseType_t xSubCommandStringLength;
	unsigned int xValueA, xValueB, xValueC;

	pcPwmValueA = (char*)FreeRTOS_CLIGetParameter((char*)pcCommandString,1,&xSubCommandStringLength);
	pcPwmValueB = (char*)FreeRTOS_CLIGetParameter((char*)pcCommandString,2,&xSubCommandStringLength);
	pcPwmValueC = (char*)FreeRTOS_CLIGetParameter((char*)pcCommandString,3,&xSubCommandStringLength);

	xValueA = (uint16_t)atoi(pcPwmValueA);
	xValueB = (uint16_t)atoi(pcPwmValueB);
	xValueC = (uint16_t)atoi(pcPwmValueC);

	etpwmSetCmpA(etpwmREG5, xValueA);
	etpwmSetCmpA(etpwmREG6, xValueB);
	etpwmSetCmpA(etpwmREG7, xValueC);
	sprintf((char *)pcWriteBuffer,"PWM_A: %d PWM_B: %d PWM_C: %d", xValueA, xValueB, xValueC);
	return pdFALSE;
}

